-- utility functions and also packets

function start_game_command(msg)
    if not (network_is_server() or network_is_moderator()) then
        djui_chat_message_create("Sorry! Your permissions are in another castle.")
        return true
    end

    local playerID, np = get_specified_player(msg)
    if not (playerID and np) then return true end

    local playerColor = network_get_player_text_color_string(playerID)
    gGlobalSyncTable.hider = np.globalIndex
    gGlobalSyncTable.hiding = true
    gGlobalSyncTable.gameEnd = false
    djui_chat_message_create("Chose " .. playerColor .. np.name .. "\\#dcdcdc\\ to hide!")
    return true
end

--hook_chat_command("start", "[NAME|ID] - Mods only; Have this player hide (use /players to see IDs)", start_game_command)

function hide_time_command(msg)
    if not (network_is_server() or network_is_moderator()) then
        djui_chat_message_create("Sorry! Your permissions are in another castle.")
        return true
    end

    local num = tonumber(msg)
    if num == nil or num < 0 or num > 86400 or (num % 1 ~= 0) then
        djui_chat_message_create("Invalid number!")
        return true
    end

    gGlobalSyncTable.maxHideTime = num
    --[[if num ~= 0 then
        djui_chat_message_create("Set hiding time to " .. num .. " second(s).")
    else
        djui_chat_message_create("Set hiding time to infinity.")
    end]]
    return true
end

--[[hook_chat_command("hidetime", "[NUM] - Mods only; Set a time, in seconds, the hider has to hide (0 for infinite)",
    hide_time_command)]]

function seek_time_command(msg)
    if not (network_is_server() or network_is_moderator()) then
        djui_chat_message_create("Sorry! Your permissions are in another castle.")
        return true
    end

    local num = tonumber(msg)
    if num == nil or num < 0 or num > 86400 or (num % 1 ~= 0) then
        djui_chat_message_create("Invalid number!")
        return true
    end

    gGlobalSyncTable.maxSeekTime = num
    --[[if num ~= 0 then
        djui_chat_message_create("Set seeking time to " .. num .. " second(s).")
    else
        djui_chat_message_create("Set seeking time to infinity (ends when one is left).")
    end]]
    return true
end

--[[hook_chat_command("seektime",
    "[NUM] - Mods only; Set a time, in seconds, the seekers have to seek (0 for infinite, which ends when only one seeker is left)",
    seek_time_command)]]

function hide_command()
    if get_hide_index() ~= 0 then
        djui_chat_message_create("You... aren't the hider.")
        return true
    elseif not gGlobalSyncTable.hiding then
        djui_chat_message_create("No going back now.")
        return true
    end
    gGlobalSyncTable.hiding = false
    autoSSTimer = gGlobalSyncTable.firstSSTime * 30
    djui_chat_message_create("You've made your choice. Good luck...")
    return true
end

hook_chat_command("hide", "- Hider only; Pick this spot to hide", hide_command)

function stop_command()
    if not (network_is_server() or network_is_moderator()) then
        djui_chat_message_create("Sorry! Your permissions are in another castle.")
        return true
    elseif get_hide_index() == 255 then
        djui_chat_message_create("THERE IS NO GAME")
        return true
    end

    network_send_include_self(true, {
        id = PACKET_GAME_END,
    })
    return true
end

--hook_chat_command("stop", "- Mods only; end the game early", stop_command)

function hint_command(msg)
    local hideIndex = get_hide_index()
    if hideIndex ~= 0 and not (network_is_server() or network_is_moderator()) then
        djui_chat_message_create("You... aren't the hider. Or a moderator.")
        return true
    elseif msg == nil then
        djui_chat_message_create("You should actually type a hint. Just saying.")
        return true
    end

    network_send_include_self(true, {
        id = PACKET_HINT,
        from = network_global_index_from_local(0),
        msg = msg,
        mod = (hideIndex ~= 0),
    })
    return true
end

hook_chat_command("hint", "[MSG] - Hider and moderator only; Chat with players who are still searching", hint_command)

function history_command(msg)
    if not (network_is_server() or network_is_moderator()) then
        djui_chat_message_create("Sorry! Your permissions are in another castle.")
        return true
    end

    local num = tonumber(msg)
    if #prevChatMessages == 0 then
        djui_chat_message_create("Silence... (no chat messages yet)")
        return true
    elseif num == nil then
        num = math.min(10, #prevChatMessages)
    elseif num < 1 or (num % 1 ~= 0) then
        djui_chat_message_create("Invalid number!")
        return true
    elseif num > #prevChatMessages then
        num = #prevChatMessages
    end

    local np = gNetworkPlayers[0]
    local playerColor = network_get_player_text_color_string(0)
    local name = playerColor .. np.name
    network_send_include_self(false, { -- no cheating
        id = PACKET_CHAT_HISTORY_NOTICE,
        name = name,
    })
    for i = #prevChatMessages - num + 1, #prevChatMessages do
        djui_chat_message_create(prevChatMessages[i])
    end

    return true
end

--hook_chat_command("chathistory", "[NUM] - Mods only; See previous chat messages", history_command)

function queue_command()
    local myGlobalIndex = network_global_index_from_local(0)
    if get_hide_index() == 0 then
        play_star_fanfare()
        djui_chat_message_create("Congrats, you've found the hidden \\#00bdff\\TR\\#ff92ff\\AN\\#ffffff\\S RI\\#ff92ff\\GH\\#00bdff\\TS\\#dcdcdc\\ message! Also, \\#ffff50\\you're hider right now.")
    elseif gGlobalSyncTable.selectionType == 0 then
        djui_chat_message_create("The next hider will be chosen \\#ffff50\\manually\\#dcdcdc\\.")
    elseif gGlobalSyncTable.nextHider == myGlobalIndex then
        djui_chat_message_create("You will be hider \\#ffff50\\next round\\#dcdcdc\\!")
    elseif gPlayerSyncTable[0].afk then
        djui_chat_message_create("\\#ff5050\\You won't be made hider because you're AFK. Press a button!")
    elseif gGlobalSyncTable.selectionType == 1 then
        djui_chat_message_create("The next hider will be chosen at \\#ffff50\\random\\#dcdcdc\\.")
    elseif gGlobalSyncTable.selectionType == 3 then
        djui_chat_message_create("\\#ffff50\\The winner\\#dcdcdc\\ will be hider next round.")
    else
        local np = network_player_from_global_index(gGlobalSyncTable.hider)
        local spot = 0
        if not np then
            if network_is_server() then
                djui_chat_message_create("You will be hider \\#ffff50\\next round\\#dcdcdc\\!")
                return true
            else
                np = gNetworkPlayers[1]
            end
            spot = spot + 1
        end
        local prevNP

        while spot <= MAX_PLAYERS do
            prevNP = np
            np = network_player_from_global_index(get_next_hider(np.globalIndex))
            spot = spot + 1
            if np.localIndex == 0 then
                if spot == 1 then
                    djui_chat_message_create("You will be hider \\#ffff50\\next round\\#dcdcdc\\!")
                elseif not prevNP then
                    local place = placeString(spot)
                    djui_chat_message_create("You will go \\#ffff50\\"..place.."\\#dcdcdc\\ from now.")
                else
                    local playerColor = network_get_player_text_color_string(prevNP.localIndex)
                    local name = playerColor .. prevNP.name
                    local place = placeString(spot)
                    djui_chat_message_create("You will go \\#ffff50\\"..place.."\\#dcdcdc\\ from now, after "..name.."\\#dcdcdc\\.")
                end

                break
            end
        end
    end
    return true
end

hook_chat_command("queue", "- See your position in the queue", queue_command)

function view_blacklist()
    local firstTime = true
    for data, v in pairs(game_blacklist) do
        if type(data) == "number" then
            if firstTime then
                djui_chat_message_create("Blacklisted areas:")
                firstTime = false
            end
            local level = data // 10
            local area = data % 10
            local text = get_level_name_custom(level_to_course[level], level, area)
            if level == LEVEL_CASTLE and area == 0 then
                text = "Inside Castle"
            elseif level == LEVEL_BOWSER_1 then
                text = "Bowser 1"
            elseif level == LEVEL_BOWSER_2 then
                text = "Bowser 2"
            elseif level == LEVEL_BOWSER_3 then
                text = "Bowser 3"
            end

            if (level ~= LEVEL_CASTLE or area > 3) and area ~= 0 then
                text = text .. " (Area " .. area .. ")"
            end
            djui_chat_message_create(text)
        end
    end

    if firstTime then
        djui_chat_message_create("No blacklisted areas!")
    end
end

function view_past_hints(msg)
    local num = tonumber(msg)
    if #pastHints == 0 then
        djui_chat_message_create("Silence... (no hints yet)")
        return true
    elseif num == nil or num == 0 then
        num = math.min(10, #pastHints)
    elseif num < 1 or (num % 1 ~= 0) then
        djui_chat_message_create("Invalid number!")
        return true
    elseif num > #pastHints then
        num = #pastHints
    end

    for i = #pastHints - num + 1, #pastHints do
        djui_chat_message_create(pastHints[i])
    end

    return true
end

function get_hide_index(ignoreEnd)
    if gGlobalSyncTable.gameEnd and not ignoreEnd then return 255 end
    return network_local_index_from_global(gGlobalSyncTable.hider)
end

local DISABLE_CENSOR = false
local old_level_names = {}
function censor_levels_and_list(censor)
    if DISABLE_CENSOR then censor = false end
    if censor == (gServerSettings.enablePlayerList == 0) then return end
    if censor then
        gServerSettings.enablePlayerList = 0
        for i = 0, COURSE_MAX - 1 do
            table.insert(old_level_names, get_level_name_ascii(i, 0, 1, -1))
            --djui_chat_message_create(tostring(old_level_names[i + 1]))
            smlua_text_utils_course_name_replace(i, "???")
        end
    else
        gServerSettings.enablePlayerList = 1
        if #old_level_names ~= 0 then
            for i = 0, COURSE_MAX - 1 do
                smlua_text_utils_course_name_replace(i, old_level_names[i + 1])
            end
        else
            for i = 0, COURSE_MAX - 1 do
                smlua_text_utils_course_name_reset(i)
            end
        end
    end
end

-- used for hud options
function get_level_name_custom(courseNum, levelNum, areaIndex)
    local name = get_level_name(courseNum, levelNum, areaIndex)
    if name ~= "???" then return name end
    return old_level_names[courseNum + 1] or "???"
end

-- from MarioHunt
function get_specified_player(msg)
    local playerID = tonumber(msg)
    if msg == "" then
        return 0, gNetworkPlayers[0]
    end

    local np = nil
    if not playerID then
        for i = 0, (MAX_PLAYERS - 1) do
            np = gNetworkPlayers[i]
            if remove_color(np.name) == remove_color(msg) then
                playerID = i
                break
            end
        end

        if not playerID then
            local subname = remove_color(msg):lower()
            for i = 0, (MAX_PLAYERS - 1) do -- try sub name
                np = gNetworkPlayers[i]
                local name = remove_color(np.name):lower()
                if name:find(subname) then
                    playerID = i
                    break
                end
            end

            if not playerID then
                djui_chat_message_create("No such player: " .. msg)
                return nil
            end
        end
    elseif playerID ~= math.floor(playerID) or playerID < 0 or playerID > (MAX_PLAYERS - 1) then
        djui_chat_message_create("Invalid id: " .. msg)
        return nil
    else
        np = network_player_from_global_index(playerID)
        playerID = (np and np.localIndex)
    end
    if not (np and np.connected) then
        djui_chat_message_create("No such player: " .. msg)
        return nil
    end

    return playerID, np
end

-- prints text on the screen... with color! (PLUS RENDER HEAD)
function djui_hud_print_text_with_color(text, x, y, scale, alpha)
    djui_hud_set_color(255, 255, 255, alpha or 255)
    local space = 0
    local color = ""
    local render = ""
    local r, g, b, a = 255, 255, 255, 255
    text, color, render = remove_color(text, true)
    while render do
        djui_hud_print_text(render, x + space, y, scale);
        space = space + djui_hud_measure_text(render) * scale
        if color and color:sub(1, 5) == "\\HEAD" then
            local head = tonumber(color:sub(6, -2))
            if head and head ~= 255 then
                space = space + 4 * scale
                render_player_head(head, x + space, y + scale * 6, scale * 1.5, scale * 1.5, true)
                space = space + 26 * scale
            end
        else
            r, g, b, a = convert_color(color)
        end
        if r then djui_hud_set_color(r, g, b, alpha or a) end
        text, color, render = remove_color(text, true)
    end
    djui_hud_print_text(text, x + space, y, scale);
end

-- removes color string
function remove_color(text, get_color)
    local start = text:find("\\")
    local next = 1
    while (next ~= nil) and (start ~= nil) do
        start = text:find("\\")
        if start ~= nil then
            next = text:find("\\", start + 1)
            if next == nil then
                next = text:len() + 1
            end

            if get_color then
                local color = text:sub(start, next)
                local render = text:sub(1, start - 1)
                text = text:sub(next + 1)
                return text, color, render
            else
                text = text:sub(1, start - 1) .. text:sub(next + 1)
            end
        end
    end
    return text
end

-- converts hex string to RGB values
function convert_color(text)
    if text:sub(2, 2) ~= "#" then
      return nil
    end
    text = text:sub(3, -2)
    local rstring, gstring, bstring = "", "", ""
    if text:len() ~= 3 and text:len() ~= 6 then return 255, 255, 255, 255 end
    if text:len() == 6 then
      rstring = text:sub(1, 2) or "ff"
      gstring = text:sub(3, 4) or "ff"
      bstring = text:sub(5, 6) or "ff"
    else
      rstring = text:sub(1, 1) .. text:sub(1, 1)
      gstring = text:sub(2, 2) .. text:sub(2, 2)
      bstring = text:sub(3, 3) .. text:sub(3, 3)
    end
    local r = tonumber("0x" .. rstring) or 255
    local g = tonumber("0x" .. gstring) or 255
    local b = tonumber("0x" .. bstring) or 255
    return r, g, b, 255 -- alpha is no longer writeable
  end

-- gets distance, pitch, and yaw between two points
function vec3f_get_dist_and_angle_lua(from, to)
    local x = to.x - from.x
    local y = to.y - from.y
    local z = to.z - from.z

    dist = math.sqrt(x * x + y * y + z * z)
    pitch = atan2s(math.sqrt(x * x + z * z), y)
    yaw = atan2s(z, x)
    return dist, pitch, yaw
end

-- from extended moveset
function limit_angle(a)
    return (a + 0x8000) % 0x10000 - 0x8000
end

function get_next_hider(hider)
    local valid = {}
    local validIfNone = {}
    local minFound = 255
    local foundHider = false
    for i = 0, MAX_PLAYERS - 1 do
        local np = network_player_from_global_index(i)

        if gGlobalSyncTable.selectionType == 2 and hider == i then
            foundHider = true
        end

        if np and np.connected and (not gPlayerSyncTable[np.localIndex].afk) then
            local index = np.localIndex
            table.insert(validIfNone, i)
            if gGlobalSyncTable.selectionType == 2 then
                if foundHider and hider ~= i then
                    table.insert(valid, i)
                    break
                end
            elseif gGlobalSyncTable.selectionType == 3 then
                if gPlayerSyncTable[index].found and gPlayerSyncTable[index].found ~= 0 and gPlayerSyncTable[index].found <= minFound then
                    if gPlayerSyncTable[index].found ~= minFound then
                        minFound = gPlayerSyncTable[index].found
                        valid = {}
                    end
                    table.insert(valid, i)
                end
            end
        end
    end

    if #valid == 0 then
        if #validIfNone == 0 then return 0 end
        if gGlobalSyncTable.selectionType == 2 then
            return validIfNone[1]
        end
        return validIfNone[math.random(1, #validIfNone)]
    end
    return valid[math.random(1, #valid)]
end

lobby_list = {
    LEVEL_BOB,
    LEVEL_WF,
    LEVEL_JRB,
    LEVEL_CCM,
    LEVEL_BBH,
    LEVEL_SSL,
    LEVEL_HMC,
    LEVEL_WDW,
    LEVEL_THI,
    LEVEL_TTC,
    LEVEL_RR,
    LEVEL_BITDW,
    LEVEL_WMOTR,
}
gGlobalSyncTable.lobbyLevel = math.random(1, #lobby_list)
function warp_to_lobby()
    ---@type NetworkPlayer
    local np = gNetworkPlayers[0]
    local level = lobby_list[gGlobalSyncTable.lobbyLevel]
    if np.currLevelNum ~= level or np.currActNum ~= 7 or np.currAreaIndex ~= 1 then
        warp_to_level(level, 1, 7)
    end
end

function on_packet_hint(data)
    if data.rawMsg then
        table.insert(pastHints, data.msg)
        if #pastHints > 100 then
            table.remove(pastHints, 1)
        end
        return
    end

    local np = network_player_from_global_index(data.from)
    local playerColor = network_get_player_text_color_string(np.localIndex)
    local name = playerColor .. np.name
    local tag = " \\#ff80ff\\[HINT]"
    if data.mod then
        tag = ""
    end

    table.insert(pastHints, (name .. tag .. "\\#6e6e6e\\: " .. data.msg))
    if #pastHints > 100 then
        table.remove(pastHints, 1)
    end

    djui_chat_message_create(name .. tag .. "\\#dcdcdc\\: " .. data.msg)
    table.insert(prevChatMessages, (name .. tag .. "\\#6e6e6e\\: " .. data.msg))
    if #prevChatMessages > 200 then
        table.remove(prevChatMessages, 1)
    end

    if np.localIndex == 0 then
        play_sound(SOUND_MENU_MESSAGE_DISAPPEAR, gMarioStates[0].marioObj.header.gfx.cameraToObject)
    else
        play_sound(SOUND_MENU_MESSAGE_APPEAR, gMarioStates[0].marioObj.header.gfx.cameraToObject)
    end
end

function on_packet_game_end(data)
    gGlobalSyncTable.gameEnd = true
    gGlobalSyncTable.hiding = false
    gGlobalSyncTable.autoTimer = 0
    local hideIndex = get_hide_index(true)
    play_race_fanfare()

    if data.dc then
        djui_chat_message_create("Round over! (The hider disconnected)")
    else
        djui_chat_message_create("Round over!")
    end

    local nonFinders = {}
    local oneFound = false
    for i = 0, MAX_PLAYERS - 1 do
        local np = gNetworkPlayers[i]
        if np.connected and hideIndex ~= i then
            if gPlayerSyncTable[i].found and gPlayerSyncTable[i].found ~= 0 then
                oneFound = true
            else
                local playerColor = network_get_player_text_color_string(i)
                local name = playerColor .. np.name
                table.insert(nonFinders, name)
            end
        end
    end

    if #nonFinders == 0 then
        djui_chat_message_create("\\#ffff50\\Everyone found the hider!")
    elseif oneFound then
        djui_chat_message_create("\\#ff5050\\Did not find:")
        for i, name in ipairs(nonFinders) do
            djui_chat_message_create(name)
        end
    else
        djui_chat_message_create("\\#ff5050\\No one found the hider!")
    end
end

function on_packet_send_ss(data)
    table.insert(screenshots, data)
    if data.notify then
        play_sound(SOUND_MENU_REVERSE_PAUSE + 61569, gMarioStates[0].marioObj.header.gfx.cameraToObject)
        djui_chat_message_create("Screenshot received! Press L + R or type /view to view!")
    end
end

function on_packet_request_game_info(data)
    local index = data.index -- sent to host, so global index and local index are the same
    for i, data in ipairs(screenshots) do
        data.notify = (i == #screenshots)
        network_send_to(index, true, data)
    end
    for i, msg in ipairs(pastHints) do
        network_send_to(index, true, {
            id = PACKET_HINT,
            msg = msg,
            rawMsg = true,
        })
    end
    network_send_to(index, true, game_blacklist)
end

function on_packet_chat_history_notice(data)
    djui_chat_message_create(data.name .. "\\#ffffff\\ is looking at chat history.")
end

function on_packet_send_blacklist(data, self)
    if self then
        if network_is_server() then
            local save = "x_" .. hackName
            local stringData = ""
            for data, v in pairs(game_blacklist) do
                if type(data) == "number" then
                    stringData = stringData .. string.format("%x", data) .. "."
                end
            end
            if stringData:len() > 256 then
                stringData = stringData:sub(1, 256)
            end
            if stringData:len() == 0 then
                stringData = "none" -- can't store empty string
            else
                stringData = stringData:sub(1, -2)
            end
            mod_storage_save(save, stringData)
        end
    else
        game_blacklist = data
    end
end

function on_packet_receive(data)
    if sPacketTable[data.id] then
        sPacketTable[data.id](data, false)
    end
end

hook_event(HOOK_ON_PACKET_RECEIVE, on_packet_receive)

PACKET_HINT = 1
PACKET_GAME_END = 2
PACKET_SEND_SS = 3
PACKET_REQUEST_GAME_INFO = 4
PACKET_CHAT_HISTORY_NOTICE = 5
PACKET_SEND_BLACKLIST = 6
sPacketTable = {
    [PACKET_HINT] = on_packet_hint,
    [PACKET_GAME_END] = on_packet_game_end,
    [PACKET_SEND_SS] = on_packet_send_ss,
    [PACKET_REQUEST_GAME_INFO] = on_packet_request_game_info,
    [PACKET_CHAT_HISTORY_NOTICE] = on_packet_chat_history_notice,
    [PACKET_SEND_BLACKLIST] = on_packet_send_blacklist,
}

function network_send_include_self(reliable, data)
    network_send(reliable, data)
    if sPacketTable[data.id] then
        sPacketTable[data.id](data, true)
    end
end

-- debug
function djui_command()
    djui_open_pause_menu()
    return true
end

function false_hider(msg)
    gGlobalSyncTable.hider = MAX_PLAYERS - 1
    gGlobalSyncTable.hiding = (msg and msg:lower() == "hide")
    gGlobalSyncTable.gameEnd = false
    take_auto_screenshot()
    return true
end

function false_found()
    gPlayerSyncTable[0].found = (gPlayerSyncTable[0].found == 1 and 0) or 1
    gGlobalSyncTable.foundPercent = 101
    return true
end

function disable_censor()
    DISABLE_CENSOR = not DISABLE_CENSOR
    return true
end

local level_list = {}
function add_log(ss)
    local np = gNetworkPlayers[0]
    if gGlobalSyncTable.hiding then
        level_list = {}
    elseif ss or viewScreenshot == 0 then
        table.insert(level_list,
            { np.currLevelNum, np.currAreaIndex, np.currActNum, viewScreenshot, prevLocData.level, prevLocData.area,
                prevLocData.area, ssWaitForWarp })
    end
end

--hook_event(HOOK_ON_SYNC_VALID, add_log)

function debug_logs()
    local np = gNetworkPlayers[0]
    for i, data in ipairs(level_list) do
        local text = string.format("Level %d Area %d Act %d (screenshot: %d, warp timer: %d)", data[1], data[2], data[3],
            data[4], data[8])
        djui_chat_message_create(tostring(i) .. ": " .. text)
        text = string.format("Level %d Area %d Act %d", data[5], data[6], data[7])
        djui_chat_message_create("Warp loc: " .. text)
    end
    if not np.currAreaSyncValid then
        djui_chat_message_create("Not synced!")
    end
    djui_chat_message_create("Your current action: " .. tostring(gMarioStates[0].action))
    return true
end

--[[hook_chat_command("logs", " - Use if you get stuck in Loading... or teleport randomly, I need to fix this bug",
    debug_logs)

if network_is_server() and get_local_discord_id() == "409438020870078486" then
    hook_chat_command("djui", "- Opens djui menu", djui_command)
    hook_chat_command("hideTest", "[HIDE] - Test hider state", false_hider)
    hook_chat_command("censor", "- Toggle censor state", disable_censor)
    hook_chat_command("foundTest", "- Test found state", false_found)
end]]

-- get place string (1st, 2nd, etc.)
function placeString(num)
    local twoDigit = num % 100
    local oneDigit = num % 10
    if twoDigit > 3 and twoDigit < 20 then
        return tostring(num) .. "th"
    elseif oneDigit == 1 then
        return tostring(num) .. "st"
    elseif oneDigit == 2 then
        return tostring(num) .. "nd"
    elseif oneDigit == 3 then
        return tostring(num) .. "rd"
    end
    return tostring(num) .. "th"
end

-- Converts string into a table using a determiner (but stop splitting after a certain amount)
function split(s, delimiter, limit_)
    local limit = limit_ or 999
    local result = {}
    local finalmatch = ""
    local i = 0
    for match in (s):gmatch(string.format("[^%s]+", delimiter)) do
        --djui_chat_message_create(match)
        i = i + 1
        if i >= limit then
            finalmatch = finalmatch .. match .. delimiter
        else
            table.insert(result, match)
        end
    end
    if i >= limit then
        finalmatch = string.sub(finalmatch, 1, string.len(finalmatch) - string.len(delimiter))
        table.insert(result, finalmatch)
    end
    return result
end

level_to_course = {
    [LEVEL_CASTLE_GROUNDS] = COURSE_NONE,   -- Course 0
    [LEVEL_CASTLE] = COURSE_NONE,           -- Course 0
    [LEVEL_CASTLE_COURTYARD] = COURSE_NONE, -- Course 0
    [LEVEL_BOB] = COURSE_BOB,               -- Course 1
    [LEVEL_WF] = COURSE_WF,                 -- Course 2
    [LEVEL_JRB] = COURSE_JRB,               -- Course 3
    [LEVEL_CCM] = COURSE_CCM,               -- Course 4
    [LEVEL_BBH] = COURSE_BBH,               -- Course 5
    [LEVEL_HMC] = COURSE_HMC,               -- Course 6
    [LEVEL_LLL] = COURSE_LLL,               -- Course 7
    [LEVEL_SSL] = COURSE_SSL,               -- Course 8
    [LEVEL_DDD] = COURSE_DDD,               -- Course 9
    [LEVEL_SL] = COURSE_SL,                 -- Course 10
    [LEVEL_WDW] = COURSE_WDW,               -- Course 11
    [LEVEL_TTM] = COURSE_TTM,               -- Course 12
    [LEVEL_THI] = COURSE_THI,               -- Course 13
    [LEVEL_TTC] = COURSE_TTC,               -- Course 14
    [LEVEL_RR] = COURSE_RR,                 -- Course 15
    [LEVEL_BITDW] = COURSE_BITDW,           -- Course 16
    [LEVEL_BOWSER_1] = COURSE_BITDW,        -- Course 16
    [LEVEL_BITFS] = COURSE_BITFS,           -- Course 17
    [LEVEL_BOWSER_2] = COURSE_BITFS,        -- Course 17
    [LEVEL_BITS] = COURSE_BITS,             -- Course 18
    [LEVEL_BOWSER_3] = COURSE_BITS,         -- Course 18
    [LEVEL_PSS] = COURSE_PSS,               -- Course 19
    [LEVEL_COTMC] = COURSE_COTMC,           -- Course 20
    [LEVEL_TOTWC] = COURSE_TOTWC,           -- Course 21
    [LEVEL_VCUTM] = COURSE_VCUTM,           -- Course 22
    [LEVEL_WMOTR] = COURSE_WMOTR,           -- Course 23
    [LEVEL_SA] = COURSE_SA,                 -- Course 24
    [LEVEL_ENDING] = COURSE_CAKE_END,       -- Course 25
}
